source ./virtualenv/bin/activate

dataset="CelebA"
ood_datasets="CelebA-Mustache CelebA-Bald CelebA-Eyeglasses"

model_name="ResNet50"
run_name="good"



model_seeds=(1 2 3)

echo "#######################################################################################################################################"
echo "#######################################################################################################################################"
echo "#######################################################################################################################################"
echo "SCOD"
n_vecs=(10)
for model_seed in "${model_seeds[@]}"
do
    for n_vec in "${n_vecs[@]}"
    do
        echo "Model seed: $model_seed, n_vec: $n_vec"
        python compute_ood_score.py --ID_dataset $dataset --OOD_datasets $ood_datasets --model $model_name --model_seed $model_seed --run_name $run_name --score scod --n_eigenvec_hm $n_vec --subsample_trainset 100 --test_batch_size 32
    done
done

echo "#######################################################################################################################################"
echo "#######################################################################################################################################"
echo "#######################################################################################################################################"
echo "SWAG"
n_vecs=(10)
for model_seed in "${model_seeds[@]}"
do
    for n_vec in "${n_vecs[@]}"
    do
        python compute_ood_score.py --ID_dataset $dataset --OOD_datasets $ood_datasets --model $model_name --model_seed $model_seed --run_name $run_name --score swag --swag_n_vec $n_vec --swag_momentum 0.99 --swag_collect_interval 100 --test_batch_size 32
    done
done



echo "#######################################################################################################################################"
echo "#######################################################################################################################################"
echo "#######################################################################################################################################"
echo "Sketched Lanczos"
lanczos_seeds=(1)
subsample_trainsets=(100)
sketch_sizes=(10000)


lanczos_lm_iters=(100)
lanczos_hm_iters=(0)
for lanczos_hm_iter in "${lanczos_hm_iters[@]}"
do
    for sketch_size in "${sketch_sizes[@]}"
    do
        for model_seed in "${model_seeds[@]}"
        do
            for lanczos_seed in "${lanczos_seeds[@]}"
            do
                echo "#######################################################################################################"
                echo "Scoring $model_name on $dataset (model seed $model_seed - lanczos seed $lanczos_seed)"
                for subsample_trainset in "${subsample_trainsets[@]}"
                do
                    for lanczos_lm_iter in "${lanczos_lm_iters[@]}"
                    do
                        echo " --  $subsample_trainset datapoint and $lanczos_hm_iter iterations high memory lanczos"
                        python compute_ood_score.py --ID_dataset $dataset --OOD_datasets $ood_datasets --model $model_name --model_seed $model_seed --run_name $run_name --subsample_trainset $subsample_trainset --lanczos_hm_iter $lanczos_hm_iter --lanczos_lm_iter $lanczos_lm_iter --lanczos_seed $lanczos_seed --sketch srft --sketch_size $sketch_size --test_batch_size 32
                    done
                done
            done
        done
    done
done

echo "#######################################################################################################################################"
echo "#######################################################################################################################################"
echo "#######################################################################################################################################"
echo "Linearized Laplace and Local Ensembles"
lanczos_seeds=(1)
subsample_trainsets=(100)
lanczos_hm_iters=(10)


for model_seed in "${model_seeds[@]}"
do
    for lanczos_seed in "${lanczos_seeds[@]}"
    do
        for subsample_trainset in "${subsample_trainsets[@]}"
        do
            for lanczos_hm_iter in "${lanczos_hm_iters[@]}"
            do
                python compute_ood_score.py --ID_dataset $dataset --OOD_datasets $ood_datasets --model $model_name --model_seed $model_seed --run_name $run_name --subsample_trainset $subsample_trainset --lanczos_hm_iter $lanczos_hm_iter --lanczos_lm_iter 0 --lanczos_seed $lanczos_seed --use_eigenvals --test_batch_size 32
                python compute_ood_score.py --ID_dataset $dataset --OOD_datasets $ood_datasets --model $model_name --model_seed $model_seed --run_name $run_name --subsample_trainset $subsample_trainset --lanczos_hm_iter $lanczos_hm_iter --lanczos_lm_iter 0 --lanczos_seed $lanczos_seed --test_batch_size 32
            done
        done
    done
done


echo "#######################################################################################################################################"
echo "#######################################################################################################################################"
echo "#######################################################################################################################################"
echo "Diag Laplace"
for model_seed in "${model_seeds[@]}"
do
    python compute_ood_score.py --ID_dataset $dataset --OOD_datasets $ood_datasets --model $model_name --model_seed $model_seed --run_name $run_name --score diagonal_lla --test_batch_size 32  --subsample_trainset 100
done


model_seeds=(1)
echo "#######################################################################################################################################"
echo "#######################################################################################################################################"
echo "#######################################################################################################################################"
echo "Deep Ensembles"
ensemble_sizes=(10)
for model_seed in "${model_seeds[@]}"
do
    for ensemble_size in "${ensemble_sizes[@]}"
    do
        python compute_ood_score.py --ID_dataset $dataset --OOD_datasets $ood_datasets --model $model_name --model_seed $model_seed --run_name $run_name --score ensemble --ensemble_size $ensemble_size --test_batch_size 32
    done
done
